%------------------------------------------------------------------------------
% File     : PHI006^5 : TPTP v9.2.0. Released v6.4.0.
% Domain   : Philosophy
% Problem  : Inconsistency of the axioms in Goedel's original manuscript
% Version  : [Ben16] axioms : Biased > Reduced > Biased.
% English  :

% Refs     : [Ben16] Benzmueller (2016), Email to Geoff Sutcliffe
% Source   : [Ben16]
% Names    : Inconsistency_S5U_direct.p [Ben16]

% Status   : ContradictoryAxioms
% Rating   : 0.22 v9.1.0, 0.12 v9.0.0, 0.20 v8.2.0, 0.31 v8.1.0, 0.27 v7.5.0, 0.14 v7.4.0, 0.67 v7.3.0, 0.56 v7.2.0, 0.50 v7.1.0, 0.62 v7.0.0, 0.57 v6.4.0
% Syntax   : Number of formulae    :   52 (  23 unt;  25 typ;  22 def)
%            Number of atoms       :   85 (  23 equ;   0 cnn)
%            Maximal formula atoms :   10 (   3 avg)
%            Number of connectives :   96 (   4   ~;   2   |;   3   &;  84   @)
%                                         (   1 <=>;   2  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   15 (   2 avg)
%            Number of types       :    3 (   1 usr)
%            Number of type conns  :  146 ( 146   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   35 (  32 usr;  10 con; 0-3 aty)
%            Number of variables   :   67 (  57   ^;   6   !;   4   ?;  67   :)
% SPC      : TH0_CAX_EQU_NAR

% Comments : This problem file has been generated by Sledgehammer.
%          : The $false conjecture makes this correspond to the Isabelle
%            sources. Otherwise it could be omitted and the status would be
%            Unsatisfiable.
%------------------------------------------------------------------------------
include('Axioms/LCL017^0.ax').
%------------------------------------------------------------------------------
%----Signature
thf(positive_tp,type,
    positive: ( mu > $i > $o ) > $i > $o ).

thf(god_tp,type,
    god: mu > $i > $o ).

%----Constant symbol for essence: ess
thf(essence_tp,type,
    essence: ( mu > $i > $o ) > mu > $i > $o ).

%----Constant symbol for necessary existence: ne
thf(necessary_existence_tp,type,
    necessary_existence: mu > $i > $o ).

%----A1: Either the property or its negation are positive, but not both.
%----(Remark: only the left to right is needed for proving T1)
thf(axA1a,axiom,
    ( mvalid
    @ ( mforall_indset
      @ ^ [Phi: mu > $i > $o] :
          ( mimplies
          @ ( positive
            @ ^ [X: mu] : ( mnot @ ( Phi @ X ) ) )
          @ ( mnot @ ( positive @ Phi ) ) ) ) ) ).

thf(axA1b,axiom,
    ( mvalid
    @ ( mforall_indset
      @ ^ [Phi: mu > $i > $o] :
          ( mimplies @ ( mnot @ ( positive @ Phi ) )
          @ ( positive
            @ ^ [X: mu] : ( mnot @ ( Phi @ X ) ) ) ) ) ) ).

%----A2: A property necessarily implied by a positive property is positive.
thf(axA2,axiom,
    ( mvalid
    @ ( mforall_indset
      @ ^ [Phi: mu > $i > $o] :
          ( mforall_indset
          @ ^ [Psi: mu > $i > $o] :
              ( mimplies
              @ ( mand @ ( positive @ Phi )
                @ ( mbox
                  @ ( mforall_ind
                    @ ^ [X: mu] : ( mimplies @ ( Phi @ X ) @ ( Psi @ X ) ) ) ) )
              @ ( positive @ Psi ) ) ) ) ) ).

%----D2: An essence of an individual is a property that is
%----necessarily implying any of its properties.
thf(defD2,definition,
    ( essence
    = ( ^ [Phi: mu > $i > $o,X: mu] :
          ( mforall_indset
          @ ^ [Psi: mu > $i > $o] :
              ( mimplies @ ( Psi @ X )
              @ ( mbox
                @ ( mforall_ind
                  @ ^ [Y: mu] : ( mimplies @ ( Phi @ Y ) @ ( Psi @ Y ) ) ) ) ) ) ) ) ).

%----D3: Necessary existence of an entity is the exemplification of all its 
%----essences.
thf(defD3,definition,
    ( necessary_existence
    = ( ^ [X: mu] :
          ( mforall_indset
          @ ^ [Phi: mu > $i > $o] :
              ( mimplies @ ( essence @ Phi @ X )
              @ ( mbox
                @ ( mexists_ind
                  @ ^ [Y: mu] : ( Phi @ Y ) ) ) ) ) ) ) ).

%----A5: Necessary existence is positive.
thf(axA5,axiom,
    mvalid @ ( positive @ necessary_existence ) ).

%---Inconsistency
thf(conj,conjecture,
    $false ).

%------------------------------------------------------------------------------
